﻿uses GraphWPF, MathExtensions;


// СРАВНИВАЕМ!
procedure DrawComparison;
begin
   Window.SetSize(1200, 600);
   Window.CenterOnScreen;
   Window.Title := 'Сравниваем спирали: Улама и обычную';
  
   var size := 15;
   var cellSize := 20;
  
   //спираль Улама:
   var offsetX1 := 50;
   var offsetY1 := 50;
  
   var ulamSpiral := new int[size, size];
   var x := size div 2;
   var y := size div 2;
   var num := 1;
  
   var dirs := Arr((0,1), (1,0), (0,-1), (-1,0));
   var dirIdx := 0;
   var steps := 1;
  
   while num <= size*size do begin
      ulamSpiral[x, y] := num;
    
     for var i := 1 to 2 do begin
         var (dx, dy) := dirs[dirIdx];
         for var j := 1 to steps do begin
             x += dx;
             y += dy;
             num += 1;
             if num <= size*size then
                ulamSpiral[x, y] := num;
         end;
         dirIdx := (dirIdx + 1) mod 4;
      end;
      steps += 1;
   end;
  
   // обычная спираль:
   var offsetX2 := 650;
   var offsetY2 := 50;
  
   var regularSpiral := new int[size, size];
   num := 1;
   for var i := 0 to size - 1 do 
       for var j := 0 to size - 1 do begin
          regularSpiral[i, j] := num;
      num += 1;
    end;

   // рисуем обе спирали:
  for var part := 0 to 1 do begin
      var offsetX := if part = 0 then offsetX1 else offsetX2;
      var offsetY := offsetY1;
      var spiral := if part = 0 then ulamSpiral else regularSpiral;
      var title := if part = 0 then ' Спираль Улама' else ' Обычная спираль (по строкам)';
    
      // надписи:
      Font.Size := 16;
      TextOut(offsetX, offsetY - 30, title);
    
      for var i := 0 to size - 1 do
          for var j := 0 to size - 1 do begin
              var cellX := offsetX + j * cellSize;
              var cellY := offsetY + i * cellSize;
              var number := spiral[i, j];
              // рисуем клетку:
              Pen.Color := Colors.LightGray;
              Brush.Color := Colors.White;
              Rectangle(cellX, cellY, cellSize, cellSize);
        
             // закрашиваем простые числа
             if number.IsPrime then begin
                Brush.Color := Colors.Blue;
               FillRectangle(cellX + 1, cellY + 1, cellSize - 2, cellSize - 2);
          end;
        
          // печатаем число:
          Brush.Color := Colors.Transparent;
          Font.Size := 8;
          var textColor := if number.IsPrime then Colors.White else Colors.Black;
          DrawText(cellX + 2, cellY + 2, cellSize - 4, cellSize - 4, 
                   number.ToString, textColor);
       end;
   end;
  
   // надписи:
   Font.Size := 12;
   TextOut(50, 400, 'В спирали Улама простые числа образуют диагональные линии.');
   TextOut(50, 420, 'В обычной спирали распределение случайное.');
  
   // статистика:
   var ulamPrimes := 0;
   var regularPrimes := 0;
  
   for var i := 0 to size - 1 do
       for var j := 0 to size - 1 do begin
           if ulamSpiral[i, j].IsPrime then ulamPrimes += 1;
           if regularSpiral[i, j].IsPrime then regularPrimes += 1;
       end;
  
   TextOut(50, 470, ' Статистика для спирали 15×15:');
   TextOut(50, 490, $' Спираль Улама: {ulamPrimes} простых чисел');
   TextOut(50, 510, $' Обычная спираль: {regularPrimes} простых чисел');
   TextOut(50, 530, ' (количество совпадает, но распределение разное!)');
end;


begin
   DrawComparison;
end.